<?php
/**
 * Account Lock
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

function saveChanges() {
    global $_POST;
    foreach($_POST as $setting) {
        if(!check_value($setting)) {
            message('error', 'Missing data (complete all fields).');
            return;
        }
    }
    $xmlPath = __PATH_ACCOUNTLOCK_ROOT__.'config.xml';
    $xml = simplexml_load_file($xmlPath);
	
	if(!Validator::UnsignedNumber($_POST['setting_2'])) throw new Exception('The unlock link expiration time must be a numeric value.');
	$xml->link_expiration_time = $_POST['setting_2'];
	
	
    $save = @$xml->asXML($xmlPath);
	if(!$save) throw new Exception('There has been an error while saving changes.');
}

if(check_value($_POST['submit_changes'])) {
	try {
		
		saveChanges();
		message('success', 'Settings successfully saved.');
		
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

if(check_value($_GET['checkusercplinks'])) {
	try {
		$AccountLock = new \Plugin\AccountLock\AccountLock();
		$AccountLock->checkPluginUsercpLinks();
		message('success', 'UserCP Links Successfully Added!');
	} catch (Exception $ex) {
		message('error', $ex->getMessage());
	}
}

// load configs
$pluginConfig = simplexml_load_file(__PATH_ACCOUNTLOCK_ROOT__.'config.xml');
if(!$pluginConfig) throw new Exception('Error loading config file.');
$pluginConfig = convertXML($pluginConfig->children());
if(!is_array($pluginConfig)) throw new Exception('Error loading config file.');

?>
<h2>Account Lock Settings</h2>
<form action="" method="post">

	<table class="table table-striped table-bordered table-hover module_config_tables">
        <tr>
            <th>Unlock Link Expiration Time<br/><span>Time limit in seconds</span></th>
            <td>
				<div class="input-group">
					<input class="form-control" type="text" name="setting_2" value="<?php echo $pluginConfig['link_expiration_time']; ?>"/>
					<div class="input-group-addon">seconds</div>
				</div>
            </td>
        </tr>
		<tr>
            <td colspan="2"><input type="submit" name="submit_changes" value="Save Changes" class="btn btn-success"/></td>
        </tr>
    </table>
</form>

<hr>

<h2>UserCP Links</h2>
<p>Click the button below to automatically add the plugin's links to the user control panel menu.</p>
<a href="<?php echo admincp_base('accountlock&page=settings&checkusercplinks=1'); ?>" class="btn btn-primary">Add UserCP Links</a>